local dialog = Dialog()
dialog:file{
    id = "save_location",
    label = "Save Location",
    title = "Save Nova",
    save = true,
    filetypes = { "nv" },
}
dialog:button {
    id = "save_button",
    text = "Save",
    onclick = function()
        local sprite = app.sprite
        local nova = {"||\n"}
        for i, slice in ipairs(sprite.slices) do
            table.insert(nova, ":slice:\n")
            local x, y, w, h = slice.bounds.x, slice.bounds.y, slice.bounds.w, slice.bounds.h
            table.insert(nova, ("    . dimensions %d %d %d %d\n"):format(x, y, w, h))
            table.insert(nova, ("    . name %s\n"):format(slice.name))
        end
        local save_location = dialog.data.save_location
        if save_location then
            local file = io.open(save_location, "w")
            file:write(table.concat(nova))
            file:close()
        end
    end
}
local data = dialog:show().data